    <?php
        /*
        * copyright (c) 2013-2021 Heliac Technologies
        * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
        *
        * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
        */
    ?>

    <form name="formAggiornamentoImpostazioniContabilita" action="../controller/controllerImpostazioni.php" method="post">
        <input type="text" class="d-none" name="operazione" value="aggiornaImpostazioniContabilita">
        <h4 class="mb-4 title">Impostazioni contabilità</h4>

        <div class="row mt-5">
            <div class="col-12">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Attiva contabilità</label>
                    <input type="checkbox" name=attivaContabilita class="js-switch" value="si" <?php echo(($impostazioni["attivaContabilita"]=="si") ? "checked" : ""); ?>  />
                    <small class="d-block text-muted">Attiva la gestione della contabilità</small>
                </div>
            </div>
            
            <div class="col-xl-6">
                <label for="descrizione" class="d-block">Tipo contabilità</label>
                <select name=tipoContabilita class="form-control">
                    <?php 
                        $tipiContabilita = ["associazione","attività commerciale"];
                        foreach($tipiContabilita as $tipoContabiltia) {
                            if($tipoContabiltia == $impostazioni["tipoContabilita"]) {
                                echo"<option value=\"$tipoContabiltia\" selected >$tipoContabiltia</option>";
                            }
                            else {
                                echo"<option value=\"$tipoContabiltia\"  >$tipoContabiltia</option>";
                            }
                        }
                    ?>
                </select>
            </div>

            <div class="form-group col-xl-6">
                <label for="descrizione" class="d-block">Percentuale IVA</label>
                <input type="number" class="form-control" id="idAppFacebook" name="percentualeIva" placeholder="Inserisci solo un numero, senza il simbolo %" value="<?php echo($impostazioni['percentualeIva']); ?>" min="0">
            </div>
            
            <div class="form-group col-xl-6">
                <label for="metadescription">Gruppo clienti</label>
                <select name=gruppoClienti class="form-control">
                    <option value="0" >Nessuno</option>
                    <?php
                        $queryComponentiDaMostrare = "SELECT * FROM geec_gruppi";
                        $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                        while($gruppo = $risComponenti->fetch_assoc()) {
                            $selezionato = "";
                            if($impostazioni["gruppoClienti"]==$gruppo["id"]) {
                                $selezionato = "selected";
                            }
                            echo"<option value=\"{$gruppo["id"]}\" $selezionato >{$gruppo["nome"]}</option>";
                        }
                    ?>
                </select>
                <small class="text-muted">Gli utenti in questo gruppo potranno essere inseriti come destinatari dei documenti fiscali generati</small>
            </div>
            
            <div class="form-group col-xl-6">
                <label for="metadescription">Gruppo fornitori</label>
                <select name="gruppoFornitori" class="form-control">
                    <option value="0" >Nessuno</option>
                    <?php
                        $queryComponentiDaMostrare = "SELECT * FROM geec_gruppi";
                        $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                        while($gruppo = $risComponenti->fetch_assoc()) {
                            $selezionato = "";
                            if($impostazioni["gruppoFornitori"]==$gruppo["id"]) {
                                $selezionato = "selected";
                            }
                            echo"<option value=\"{$gruppo["id"]}\" $selezionato >{$gruppo["nome"]}</option>";
                        }
                    ?>
                </select>
                 <small class="text-muted">Gli utenti in questo gruppo potranno essere inseriti come autori delle fatture o ricevute in entrata</small>
            </div>
        </div>
    
        <div class="row mt-5">
            <div class="form-group col-12">
                <h5>Intestazione documenti fiscali</h5>
                <hr>
            </div>
            
            <div class="form-group col-12">
                <textarea name="intestazioneDocumentiFiscali" class="tiny"><?php echo $impostazioni["intestazioneDocumentiFiscali"] ?></textarea>
                <small class="d-block text-muted">Inserisci l'intestazione dei tuoi documenti fiscali</small>
            </div>
            
            <div class="col-12">
                <button class="btn btn-primary float-right"><i class="fas fa-check"></i> Salva</button>
            </div><!--/usa questo markup se ti serve un salvataggio di una singola sezione-->
        </div>
        
        <div class="row mt-5">
            
            <div class="col-6">
                <h5>Etichette documenti</h5>
                <hr>
                <div id="tagAssociati">
                    <?php 
                        $queryTagAssociati = "SELECT * FROM geecAd_etichette WHERE tipo LIKE 'contabilita'";
                        $risNomi = $geecomDb->eseguiQueryLettura($queryTagAssociati);
                        if($risNomi->num_rows>0) {
                            while($tag = $risNomi->fetch_assoc()) {
                                echo"<div id=\"divEtichetta{$tag["id"]}\" class=\"d-inline-block mr-2 mb-2\">
                                        <button type=\"button\" class=\"btn btn-outline-primary round\" onclick=\"eliminaEtichetta({$tag["id"]})\">{$tag["nome"]}<i class=\"fas fa-times ml-2\"></i></button>
                                    </div>";
                            }
                        }
                        else {
                            echo"Nessuna etichetta presente";
                        }
                    ?>
                </div>
                <div class="input-group">
                    <input type="text" id="etichettaDaAggiungere" class="form-control" placeholder="Nuova etichetta">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-primary" onclick="aggiungiEtichetta('etichettaDaAggiungere','contabilita','tagAssociati')"><i class="fas fa-plus mr-2"></i>Aggiungi</button>
                    </div>
                </div>
                <small class="text-muted">Aggiungi una nuova etichetta per i documenti fiscali. Inserisci una etichetta per volta</small>
            </div>
            
            <div class="col-6">
                <h5>Metodi pagamento</h5>
                <hr>
                <div id="metodiPagamento">
                    <?php 
                        $queryTagAssociati = "SELECT * FROM geecAd_etichette WHERE tipo LIKE 'metodoPagamento'";
                        $risNomi = $geecomDb->eseguiQueryLettura($queryTagAssociati);
                        if($risNomi->num_rows>0) {
                            while($tag = $risNomi->fetch_assoc()) {
                                echo"<div id=\"divEtichetta{$tag["id"]}\" class=\"d-inline-block mr-2 mb-2\">
                                        <button type=\"button\" class=\"btn btn-outline-primary round\" onclick=\"eliminaEtichetta({$tag["id"]})\">{$tag["nome"]}<i class=\"fas fa-times ml-2\"></i></button>
                                    </div>";
                            }
                        }
                        else {
                            echo"Nessuna etichetta presente";
                        }
                    ?>
                </div>
                <div class="input-group">
                    <input type="text" id="pagamentoDaAggiungere" class="form-control" placeholder="Nuovo metodo di pagamento">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-primary" onclick="aggiungiEtichetta('pagamentoDaAggiungere','metodoPagamento','metodiPagamento')"><i class="fas fa-plus mr-2"></i>Aggiungi</button>
                    </div>
                </div>
                <small class="text-muted">Aggiungi una nuovo metodo di pagamento. Inseriscine uno per volta</small>
            </div>
        </div>
    </form>